package w83a.xml.datatype;

import java.io.Serializable;
import java.util.Locale;

import w83a.w83aUtilidadesComunes.W83ALocaleString;


public class W83AConsultationContext implements Serializable {

	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;

	public W83AConsultationContext(W83ALocaleString familyName, String organId,
			String departamentId, W83ALocaleString procedureName,
			W83ALocaleString departamentName, W83ALocaleString organName) {

		this.familyName = familyName;
		this.organId = organId;
		this.departamentId = departamentId;
		this.procedureName = procedureName;
		this.departamentName = departamentName;
		this.organName = organName;

	}

	public W83AConsultationContext(String procedureId,
			W83ALocaleString procedureNameLocale, String entityCode,
			String departmentId, W83ALocaleString departmentNameLocale,
			String managingUnitId, W83ALocaleString managingUnitNameLocale/*,
			String managingUnitFunction,
			String managingUnitDeliveryKeyFunction, String familyID,
			String procedureInboxID, String procedureInboxName,
			String certifiedValidationMode, String telematicsCode,
			W83ALocaleString entityNameLocale, String managingUnitInBoxID,
			String telematicActionId, W83ALocaleString telematicActionNameLocale*/) {

		this.procedureId = procedureId;
		this.procedureName = procedureNameLocale;
		this.entityCode = entityCode;
		this.departamentId = departmentId;
		this.departamentName = departmentNameLocale;
		this.organId = managingUnitId;
		this.organName = managingUnitNameLocale;
		/*this.managingUnitFunction = managingUnitFunction;
		this.managingUnitDeliveryKeyFunction = managingUnitDeliveryKeyFunction;
		this.familyID = familyID;
		this.procedureInboxID = procedureInboxID;
		this.procedureInboxName = procedureInboxName;
		this.certifiedValidationMode = certifiedValidationMode;
		this.telematicsCode = telematicsCode;
		this.entityName = entityNameLocale;
		this.managingUnitInBoxId = managingUnitInBoxID;
		this.telematicActionId = telematicActionId;
		this.telematicActionNameLocale = telematicActionNameLocale;*/

	}
		
	public W83AConsultationContext(String procedureId,//NOPMD
			W83ALocaleString procedureNameLocale, String entityCode,
			String departmentId, W83ALocaleString departmentNameLocale,
			String managingUnitId, W83ALocaleString managingUnitNameLocale,
			/*String managingUnitFunction,
			String managingUnitDeliveryKeyFunction, String familyID,
			String procedureInboxID, String procedureInboxName,
			String certifiedValidationMode, String telematicsCode,
			W83ALocaleString entityNameLocale, String managingUnitInBoxID,
			String telematicActionId, W83ALocaleString telematicActionNameLocale, */
			String documentalSeries01Id, String documentalSeries20Id, String documentalSeries48Id, String daProcedureId) {
		
		
	
		this ( procedureId, procedureNameLocale,  entityCode,
				 departmentId,  departmentNameLocale,
				 managingUnitId,  managingUnitNameLocale
				/* managingUnitFunction,
				 managingUnitDeliveryKeyFunction,  familyID,
				 procedureInboxID,  procedureInboxName,
				 certifiedValidationMode,  telematicsCode,
				 entityNameLocale,  managingUnitInBoxID,
				 telematicActionId,  telematicActionNameLocale*/);
	
		this.documentalSeries01Id=documentalSeries01Id;
		this.documentalSeries20Id=documentalSeries20Id;
		this.documentalSeries48Id=documentalSeries48Id;
		this.daProcedureId=daProcedureId;
	}
	

	public W83ALocaleString getProcedureName() {
		return procedureName;
	}

	public String getProcedureNameDesc(String languageCode) {
		return this.procedureName.getString(new Locale(languageCode));
	}

	public void setProcedureName(W83ALocaleString procedureName) {
		this.procedureName = procedureName;
	}

	public W83ALocaleString getDepartamentName() {
		return departamentName;
	}

	public String getDepartamentNameDesc(String languageCode) {
		return this.departamentName.getString(new Locale(languageCode));
	}

	public W83ALocaleString getOrganName() {
		return organName;
	}

	public String getOrganNameDesc(String languageCode) {
		return this.organName.getString(new Locale(languageCode));
	}

	public W83ALocaleString getEntityName() {
		return entityName;
	}

	public String getEntityNameDesc(String languageCode) {
		return this.entityName.getString(new Locale(languageCode));
	}

	public String getDepartamentId() {
		return departamentId;
	}

	public String getOrganId() {
		return organId;
	}

	public W83ALocaleString getFamilyName() {
		return familyName;
	}

	public String getFamilyNameDesc(String languageCode) {
		return this.familyName.getString(new Locale(languageCode));
	}

	//////
	public String getProcedureId() {
		return procedureId;
	}

	public String getEntityId() {
		return entityCode;
	}

	public String getManagingUnitFunction() {
		return managingUnitFunction;
	}

	public String getManagingUnitDeliveryKeyFunction() {
		return managingUnitDeliveryKeyFunction;
	}

	public String getFamilyID() {
		return familyID;
	}

	public String getManagingUnitInboxID() {
		return managingUnitInBoxId;
	}

	public String getProcedureInboxID() {
		return procedureInboxID;
	}

	public String getProcedureInboxName() {
		return procedureInboxName;
	}

	public String getCertifiedValidationMode() {
		return certifiedValidationMode;
	}

	public String getTelematicsCode() {
		return telematicsCode;
	}

//	private static Logger log = Logger.getLogger(W83AConsultationContext.class
//			.getName());

	/**
	 * @return Returns the telematicActionId.
	 */
	public String getTelematicActionId() {
		return telematicActionId;
	}

	/**
	 * @param telematicActionId
	 *            The telematicActionId to set.
	 */
	public void setTelematicActionId(String telematicActionId) {
		this.telematicActionId = telematicActionId;
	}

	/**
	 * @return Returns the telematicActionNameLocale.
	 */
	public W83ALocaleString getTelematicActionNameLocale() {
		return telematicActionNameLocale;
	}

	/**
	 * @param telematicActionNameLocale
	 *            The telematicActionNameLocale to set.
	 */
	public void setTelematicActionNameLocale(
			W83ALocaleString telematicActionNameLocale) {
		this.telematicActionNameLocale = telematicActionNameLocale;
	}
	
	/**
	 * @return the documentalSeries01Id
	 */
	public String getDocumentalSeries01Id() {
		return documentalSeries01Id;
	}

	/**
	 * @return the documentalSeries20Id
	 */
	public String getDocumentalSeries20Id() {
		return documentalSeries20Id;
	}

	/**
	 * @return the documentalSeries48Id
	 */
	public String getDocumentalSeries48Id() {
		return documentalSeries48Id;
	}	
	
	

	public String getDaProcedureId() {
		return daProcedureId;
	}



	private W83ALocaleString procedureName;

	private W83ALocaleString departamentName;

	private String departamentId;

	private W83ALocaleString organName;

	private String organId;

	private W83ALocaleString familyName;

	private String entityCode;

	//
	private String procedureId;

	private String managingUnitInBoxId;

	private String managingUnitFunction;

	private String managingUnitDeliveryKeyFunction;

	private String familyID;

	private String procedureInboxID;

	private String procedureInboxName;

	private String certifiedValidationMode;

	private String telematicsCode;

	private W83ALocaleString entityName;

	private String telematicActionId;

	private W83ALocaleString telematicActionNameLocale;
	
	//adaptacion platea v2.1
	private String documentalSeries01Id, documentalSeries20Id, documentalSeries48Id;
	
	private String daProcedureId;

}